<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class SettingsMigration extends Migratable {
    const modelName = 'Settings';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('setting_id');
			$blueprint->Int('splash_file_id')->Len(150);
			$blueprint->Int('logo_id')->Len(150);
			$blueprint->VarChar('app_name')->Len(150);
			$blueprint->VarChar('support_number')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
