<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ThirdCategoriesMigration extends Migratable {
    const modelName = 'ThirdCategories';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('third_category_id');
			$blueprint->VarChar('third_category_name')->Len(150);
			$blueprint->Int('first_category_id')->Len(150);
			$blueprint->Int('second_category_id')->Len(150);
			$blueprint->Int('icon_id')->Len(150);
			$blueprint->Int('banner_id')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
