<?php

use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Main\HtmlTags;

echo HtmlTags::Div(".modal.fade#imgPreviewModal")->Content(
    HtmlTags::Div('.modal-dialog')->Style(Style::raw([
        'max-width' => '90vw',
        'width'     => 'auto',
    ]))->Content(
        HtmlTags::Div('.modal-content')->Content(
            HtmlTags::Div('.modal-header')->Content(
                HtmlTags::H4('.modal-title#imgPreviewModalTitle'),
                HtmlTags::Div('.pull-left')->Content(
                    HtmlTags::Button('.close')
                        ->Content('&times;')
                        ->Data_('dismiss', 'modal')
                        ->Type('button')
                        ->Attrs(['aria-label' => 'بستن'])
                )
            ),
            HtmlTags::Div('.modal-body.text-center')->Style(Style::raw([
                'max-height' => '80vh',
                'overflow'   => 'auto',
            ]))->Content(
                HtmlTags::Img('#imgPreviewModalSource')->Src('')
                    ->Style(Style::raw([
                        'max-width'     => '100%',
                        'height'        => 'auto',
                        'object-fit'    => 'contain',
                        'display'       => 'inline-block',
                        'margin'        => 'auto',
                        'border-radius' => '10px',
                    ]))
            )
        )
    )
);

