<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;
use model\Plans;
use model\Transaction;

class UsersEntity extends EntityScheme {
    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    //    public $user_id;
    private $_plan;
    public $score;

    public function model() {
        return new \model\Users();
    }


    protected function dictionary(): array {
        return [
            'user_id' => 'user_id',
            'score'   => 'user_score',
        ];
    }

    public function plan(): ?PlansEntity {
        if ($this->_plan instanceof PlansEntity) {
            return $this->_plan;
        } else {
            $plan = Plans::get($this->plan_id);
            if ($plan instanceof PlansEntity) {
                $this->_plan = $plan;
                $this->_plan->expiresAt = $this->plan_expired_at;
                $this->_plan->isActive = $this->plan_expired_at >= time();
                return $this->plan();
            } else {
                return null;
            }
        }
    }

    public function providerFormat(): array {
        return [
            'id'           => $this->user_id,
            'image'        => is_file(__SOURCE__ . 'images/Users/' . $this->user_image) ? __IMAGES__ . 'Users/' . $this->user_image : __IMAGES__ . 'Users/placeholder.png',
            'name'         => $this->user_name . ' ' . $this->user_lastname,
            'mobile'       => $this->user_mobile,
            'currentLimit' => 0,
        ];
    }

    public function apiFormat(): array {
        $plan = $this->plan();
        return [
            'id'           => $this->user_id,
            'name'         => $this->user_name . '',
            'credit'       => (int)$this->user_credit,
            'score'        => (int)$this->user_score,
            'lastname'     => $this->user_lastname . '',
            'mobile'       => $this->user_mobile . '',
            'image'        => __IMAGES__ . 'Users/' . $this->user_image,
            'plan'         => $plan instanceof PlansEntity ? $plan->apiFormat() : null,
            'createdAt'    => strtotime($this->created_at),
            'totalBuys'    => Transaction::Db()->where('user_id', $this->user_id)->rowCount(),
            'isVerified'   => $this->is_verified == 1,
            'referralCode' => $this->user_plan_code ?? base64_encode($this->user_id),
            'info'         => [
                'nationalCode' => $this->user_national_code,
                'birthDate'    => $this->user_birthdate,
                'email'        => $this->user_email,
                'postCode'     => $this->user_postal_code,
                'sheba'        => $this->user_sheba,
                'address'      => $this->user_address,
            ],
        ];
    }

    public function commentApiFormat() {
        if (!$this->user_name && !$this->user_lastname) {
            $name = 'دوست آنیکارتی';
        } else {
            $name = $this->user_name . ' ' . $this->user_lastname;
        }
        return [
            'id'    => $this->user_id,
            'name'  => $name,
            'image' => $this->user_image ? __IMAGES__ . 'Users/' . $this->user_image : '',
        ];
    }

    public function toOption(): Option {
        return HtmlTags::Option()->Value($this->user_id)->Content($this->user_name . ' ' . $this->user_lastname . ' ' . $this->user_mobile);
    }
}
