<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class ProviderGalleriesEntity extends EntityScheme {
    public $provider_gallery_id;
    /**
     * پذیرنده
     **/
    public $id;
    /**
     * تصویر
     **/
    public $image;

    public function model() {
        return new \model\ProviderGalleries();
    }


    protected function dictionary(): array {
        return [
            'provider_gallery_id' => 'provider_gallery_id', 'id' => 'provider_id', 'image' => 'provider_image',
        ];
    }

    public function apiFormat(): array {
        return [
            'id'    => $this->id,
            'image' => __IMAGES__ . 'ProviderGalleries/' . $this->image,
        ];
    }

}
