<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class JobsEntity extends EntityScheme
{
    public $job_id;
    /**
     * عنوان
     **/
    public $title;
    /**
     * شهر
     **/
    public $state_id;
    /**
     * نوع همکاری
     **/
    public $type;
    /**
     * توضیحات
     **/
    public $description;

    public function model()
    {
        return new \model\Jobs();
    }

    public function apiFormat()
    {
        /** @var StatesEntity $state */
        $state = \model\States::get($this->state_id);
        return [
            'id' => $this->job_id,
            'title' => $this->title,
            'state' => $state->apiFormat(),
            'type' => $this->type,
        ];
    }

    public function singleApiFormat()
    {
        /** @var StatesEntity $state */
        $state = \model\States::get($this->state_id);
        return [
            'id' => $this->job_id,
            'title' => $this->title,
            'state' => $state->apiFormat(),
            'type' => $this->type,
            'description' => $this->description
        ];
    }


    protected function dictionary(): array
    {
        return [
            'job_id' => 'job_id', 'title' => 'job_title', 'state_id' => 'state_id', 'type' => 'job_type', 'description' => 'job_description',
        ];
    }
}
