<?php

namespace model\Entity;

use FwHtml\FontAwesome;
use FwHtml\Elements\Tags\Main\HtmlTags;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class FoldersEntity extends EntityScheme {
	public $folder_id;
	public $name;
	public $parent;
	
	public function model() {
		return new \model\Folders();
	}
	
	
	protected function dictionary() : array {
		return [
			'folder_id' => 'folder_id',
			'name'      => 'folder_name',
			'parent'    => 'parent_id',
		];
	}
	
	
	public function thumb() {
		return HtmlTags::I()->Class(FontAwesome::Folder_o());
	}
	
	public function id() {
		return $this->folder_id;
	}
	
	public function name() {
		return $this->name;
	}
}
