<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class FaqsEntity extends EntityScheme
{
    public $faq_id;
    /**
     * سوال
     **/
    public $question;
    /**
     * پاسخ
     **/
    public $answer;
    public $type;

    public function model()
    {
        return new \model\Faqs();
    }

    public function apiFormat()
    {
        return [
            'id' => $this->faq_id,
            'question' => $this->question,
            'answer' => $this->answer
        ];
    }


    protected function dictionary(): array
    {
        return [
            'faq_id' => 'faq_id', 'question' => 'faq_question', 'answer' => 'faq_answer', 'type' => 'faq_type',
        ];
    }
}
