<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class BlogCommentsEntity extends EntityScheme
{
    public $blog_comment_id;
    /**
     * کاربر
     **/
    public $user_id;
    /**
     * پست
     **/
    public $blog_id;
    /**
     * کامنت
     **/
    public $comment_content;

    public function model()
    {
        return new \model\BlogComments();
    }

    public function apiFormat()
    {
        $user = \model\Users::get($this->user_id);
        /** @var UsersEntity $user */
        return [
            'id' => $this->blog_comment_id,
            'user' => $user?$user->commentApiFormat():"دوست آنیکارتی",
            'comment' => $this->comment_content
        ];
    }


    protected function dictionary(): array
    {
        return [
            'blog_comment_id' => 'blog_comment_id', 'user_id' => 'user_id', 'blog_id' => 'blog_id', 'comment_content' => 'comment_content',
        ];
    }
}
