<?php

use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;

trait DropzoneUploader {
	abstract function dropzoneColumn() : string;
	
	protected function cleanDropzone($id = 0) {
		$arr = $this->requestArray();
		$images = Db::table('tblTempImages')->where([
			'related_table'  => $this->model()->_table,
			'token'          => $arr['dropzone_token'],
			'related_column' => $this->dropzoneColumn(),
		])->get()->map(function ($row) {
			return $row->image;
		})->all();
		Db::table('tblTempImages')->where([
			'related_table'  => $this->model()->_table,
			'token'          => $arr['dropzone_token'],
			'related_column' => $this->dropzoneColumn(),
		])->delete();
        if ($id > 0) {
            $item = $this->model()::get($id);
            $items = json_decode($item->{$this->dropzoneColumn()},true);
            if ($items) {
                $arr[$this->dropzoneColumn()] = array_merge($items,$images);
            } else {
                $arr[$this->dropzoneColumn()] = $images;
            }
        } else {
            $arr[$this->dropzoneColumn()] = $images;
        }
		unset($arr['dropzone_token']);
		$this->setRequestArray($arr);
	}
	
}
