<?php
namespace controller;
use ControllerScheme;
class Users extends ControllerScheme {
    const name = 'کاربر';

    public function getUserData()
    {
        $user = \model\Users::get($this->requestArray()['id']);
        $plan = $user->plan_id?\model\Plans::get($user->plan_id)->plan_name:"بدون اشتراک";
        $activated_at = $user->plan_activated_at?jdate('Y/m/d H:i',$user->plan_activated_at):"بدون تاریخ فعالسازی";
        $expired_at = $user->plan_expired_at?jdate("Y/m/d H:i",$user->plan_expired_at):"بدون تاریخ انقضا";


        echo json_encode([
            "plan" => $plan,
            'activated_at' => $activated_at,
            'expired_at' => $expired_at
        ]);

    }



    public function authenticate() {
        $users = \model\Users::Db()->where("user_national_code IS NOT NULL AND user_national_code != '' AND is_verified = 0")->get();
        return $this->view($this->viewName(), 'authenticate', [
            $users
        ]);
    }

    public function verifyUser()
    {
        $id = $this->requestArray()['id'];
        $status = $this->requestArray()['status'];
        if ($status == 1){
            if (\model\Users::edit($id,[
                'is_verified' => 1
            ])){
                return 1;
            }else{
                return 0;
            }
        }else{
            if (\model\Users::edit($id,[
                'is_verified' => 0,
                'user_name' => null,
                'user_lastname' => null,
                'user_national_code' => null,
                'user_birthdate' => null,
                'user_email' => null,
                'user_postal_code' => null,
                'user_address' => null,
                'user_sheba' => null,
                'user_image' => null,

            ])){
                return 1;
            }else{
                return 0;
            }
        }


    }
    
}