<?php

namespace controller;

use ControllerScheme;

class Settings extends ControllerScheme
{
    const name = 'تنظیمات';

    public static $__uploads = [
        "license_icon1" => __SOURCE__ . "images/Settings/",
        "license_icon2" => __SOURCE__ . "images/Settings/",
        "license_icon3" => __SOURCE__ . "images/Settings/"
    ];


    public function main()
    {
        return parent::editIndex(1); // TODO: Change the autogenerated stub

    }

    public function editIndex($key = '0')
    {
        return parent::editIndex(1); // TODO: Change the autogenerated stub
    }

//    public function edit()
//    {
//        $request = $this->requestArray();
//
//        // پاکسازی شماره تماس
//        $request['setting_tel'] = preg_replace('/[()\s]/', '', $request['setting_tel']);
//
//        // لینک‌های ثبت‌شده در فرم
//        $license_links = $request['license_links'] ?? [];
//
//        // لیست آیکون‌هایی که هنوز باقی موندن (hidden input)
//        $license_images_post = $request['license_images'] ?? [];
//        $existingUrls = array_column($license_images_post, 'url');
//
//        // حذف مجوزهایی که دیگر در فرم نیستند
//        $currentLicenses = \model\Licenses::Db()->get();
//        foreach ($currentLicenses as $license) {
//            if (!in_array($license->license_icon, $existingUrls)) {
//                $imagePath = __SOURCE__ . "images/Licenses/" . $license->license_icon;
//                if (file_exists($imagePath)) {
//                    unlink($imagePath);
//                }
//                \model\Licenses::delete($license->license_id);
//            }
//        }
//
//        // اضافه کردن فایل‌های جدید
//        $license_icons = $_FILES['license_icons'] ?? null;
//        if ($license_icons && isset($license_icons['name']) && is_array($license_icons['name'])) {
//            foreach ($license_icons['name'] as $index => $imageData) {
//                $tmpName = $license_icons['tmp_name'][$index]['file'] ?? null;
//                $error = $license_icons['error'][$index]['file'] ?? UPLOAD_ERR_NO_FILE;
//                $originalName = $license_icons['name'][$index]['file'] ?? null;
//
//                if ($error === UPLOAD_ERR_OK && $tmpName && $originalName) {
//                    $extension = pathinfo($originalName, PATHINFO_EXTENSION);
//                    $newFileName = 'license_icon_' . (int)(microtime(true) * 1000) . '.' . $extension;
//                    $destinationPath = __SOURCE__ . "images/Licenses/" . $newFileName;
//
//                    if (move_uploaded_file($tmpName, $destinationPath)) {
//                        \model\Licenses::add([
//                            'license_link' => $license_links[$index] ?? '',
//                            'license_icon' => $newFileName,
//                        ]);
//                    }
//                }
//            }
//        }
//
//        // پاک کردن فیلدهای مربوطه از request
//        unset($request['license_images']);
//        unset($request['license_links']);
//
//        // تنظیم داده برای ذخیره تنظیمات کلی
//        $this->setRequestArray($request);
//        return parent::edit();
//    }


    public function edit()
    {
        $request = $this->requestArray();

        // پاکسازی شماره تماس
        $request['setting_tel'] = preg_replace('/[()\s]/', '', $request['setting_tel']);

        // گرفتن آیکون‌های موجود از فرم (hidden input ها)
        $license_images_post = $request['license_images'] ?? [];
        $existingUrls = array_column($license_images_post, 'url');

        // حذف مواردی که دیگر در فرم نیستند
        $currentLicenses = \model\Licenses::Db()->get();
        foreach ($currentLicenses as $license) {
            if (!in_array($license->license_icon, $existingUrls)) {
                $imagePath = __SOURCE__ . "images/Licenses/" . $license->license_icon;
                if (file_exists($imagePath)) {
                    unlink($imagePath);
                }
                \model\Licenses::delete($license->license_id);
            }
        }

        // ذخیره فایل‌ها و لینک‌های جدید
        $license_icons = $_FILES['license_icons'] ?? null;
        $icon_links = $request['license_icons'] ?? [];

        if ($license_icons && isset($license_icons['name']) && is_array($license_icons['name'])) {
            foreach ($license_icons['name'] as $index => $imageData) {
                $tmpName = $license_icons['tmp_name'][$index]['file'] ?? null;
                $error = $license_icons['error'][$index]['file'] ?? UPLOAD_ERR_NO_FILE;
                $originalName = $license_icons['name'][$index]['file'] ?? null;
                $link = $icon_links[$index]['link'] ?? '';

                if ($error === UPLOAD_ERR_OK && $tmpName && $originalName) {
                    $extension = pathinfo($originalName, PATHINFO_EXTENSION);
                    $newFileName = 'license_icon_' . (int)(microtime(true) * 1000) . '.' . $extension;
                    $destinationPath = __SOURCE__ . "images/Licenses/" . $newFileName;

                    if (move_uploaded_file($tmpName, $destinationPath)) {
                        \model\Licenses::add([
                            'license_link' => $link,
                            'license_icon' => $newFileName,
                        ]);
                    }
                }
            }
        }

        // پاک‌سازی داده‌های مربوط به مجوزها از request
        unset($request['license_links']);
        unset($request['license_images']);
        unset($request['license_icons']);

        $this->setRequestArray($request);
        return parent::edit();
    }


}